/** @file parser.h
 * Parser header.
 *
 * Definitions related to the configuration parser.
 */ 
#ifndef __PARSER_H
#define __PARSER_H

#include "common.h"

namespace rpg {
	enum rpg_param_type_t {
		INT,
		FLOAT,
		STRING,
		INTLIST,
		FLOATLIST,
		STRINGLIST
	};

	struct rpg_param_value_t {
		rpg_param_type_t type;
		rpg_str_t param_name;

		rpg_int_t v_int;
		rpg_float_t v_float;
		rpg_str_t v_string;
		rpg_list_int_t v_int_list;
		rpg_list_float_t v_float_list;
		rpg_list_str_t v_string_list;
	};

	typedef std::vector<rpg_param_value_t> rpg_params_t;

	/* semantic value of the parser */
	struct cfgLval {
		rpg_int_t v_int;
		rpg_float_t v_float;
		rpg_str_t v_string;
		rpg_list_int_t v_int_list;
		rpg_list_float_t v_float_list;
		rpg_list_str_t v_string_list;
		rpg_params_t v_params;
		rpg_param_value_t v_parameter;
	};

	class dataSourceProvider;
	class dataClassProvider;

	class rpg_context_t {
		rpg_str_t  group_name;
		rpg_bool_t check_group_name;
	public:	
		dataSourceProvider& sprovider;
		dataClassProvider& cprovider;
		rpg_context_t(dataSourceProvider&  sp, dataClassProvider& cp);
		rpg_bool_t checkGroupName(const rpg_str_t& name);
		void clearGroupName();
		void setGroupName(const rpg_str_t& name);
	};
}

//--------------------------------------------------------------------------
// Tokenizer definitions

#define YY_DECL	int config_lex (rpg::cfgLval *lval, rpg::rpg_uint_t *line)
extern YY_DECL;

extern FILE *config_get_in (void );
extern void config_set_in (FILE * in_str  );
extern int config_parse (rpg::rpg_context_t& context);
extern int config_lex_destroy (void);

/// Line number from tokenizer.
extern rpg::rpg_uint_t line_number;

#endif
