package rpg;

public interface Module {

	/**
	 * Sets a name of this module.
	 * @param name a new name to be set
	 */
	public abstract void setName (String name);

	/**
	 * Retrieves a name of this module.
	 */
	public abstract String getName ();

	/**
	 * Initializes the module with no submodules connected. Each benchmark
	 * implements this method, but only leaf modules in the module architecture
	 * tree can have this method called.
	 */
	public abstract void init ();

	/**
	 * Initializes the module by connecting the supplied submodules.
	 * This method should be called only for architectural modules. Each architectural
	 * module can accept different numbers of submodules. For example a Loop
	 * module can accept one submodule, that will be the module iterated by
	 * the loop.
	 *
	 * @param modules submodules to be connected to this module
	 */
	public abstract void init (Module... modules);

	/** The wrapper for workload that provides callbacks.
	 * 
	 * This is the method that should be called from outside the module to have it work.
	 * Serialized modules are protected by their mutex.
	 */
	public abstract void measuredWork (SessionStateHolder sessionState);

	/** Measures the workload in an internal loop. */
	public abstract void measureIsolated ();

	/** Prints collected measurements. */
	public abstract void printMeasurements (String context);

	/** Clears collected measurements. */
	public abstract void clearMeasurements ();
	
	/** Print module implementation-specific information useful for model transformations. */
	public abstract void printConfiguration ();

}