#include "common.h"
#include <stdio.h>
#include <iostream>

using namespace rpg;
using namespace std;

/** Counter of errors. */
rpg_uint_t errors = 0;
/** Prefix of the printed errors. */
rpg_str_t error_prefix = "";
/** Error reporting lock for multiple threads. */
volatile int err_lock = 0;

/** Increments the error counter and prints error message on the standard
  * error device.
  * @param msg Error message to be printed.
  */
void error(rpg::rpg_str_t msg) {
	while (__sync_lock_test_and_set(&err_lock, 1) == 1) {};
	errors++;
	cerr << error_prefix << msg << endl;
	__sync_lock_release(&err_lock);
}

/** Increments the error counter and prints error message with the line on the standard
  * error device.
  * @param msg Error message to be printed.
  * @param line Line, on which the error occured.
  */
void error(rpg::rpg_str_t msg, rpg::rpg_uint_t line) {
	while (__sync_lock_test_and_set(&err_lock, 1) == 1) {};
	errors++;
	cerr << error_prefix << "line " << line << ": " << msg << endl;
	__sync_lock_release(&err_lock);
}

/** Sets the error prefix.
  * @param error_prefix_ Error prefix of the error messages.
  */
void set_err_prefix(rpg::rpg_str_t& error_prefix_) {
	error_prefix = error_prefix_;
}

/** Prints error message, if the syscall fails. Does not increment error counter.
  * @param msg Error message.
  */
void error_syscall(rpg::rpg_str_t msg) {
	perror(msg.c_str());
}
