%{
	#include <string>
	#include <iostream>
	
	#include "common.h"
	#include "config.h"
	#include "parser.h"
	
	using namespace std;
	using namespace rpg;

    /* semantic value */
    #define YYSTYPE cfgLval

	/* locations */
	#define YYLTYPE rpg_uint_t
	#define YYLLOC_DEFAULT(Cur, RHS, n) Cur = YYRHSLOC(RHS, n);
    
	/* error handler */
    static void yyerror(YYLTYPE *line, rpg::rpg_context_t& context, const char *m);
    
%}

/* tokens */
%token<v_string> 	T_IDENTIFIER
%token 				T_SEPARATOR
%token				T_EQUALS
%token<v_int>		T_INT
%token<v_float>		T_FLOAT
%token<v_string>	T_STRING
%token				T_LIST
%token 				T_LEFTBRACKET
%token				T_RIGHTBRACKET
%token				T_COMMA		

%error-verbose
%pure-parser
%locations
%parse-param {rpg_context_t& context}

%start configfile

%type<v_int_list> intlist
%type<v_float_list> floatlist
%type<v_string_list> stringlist

%type<v_int_list> intvect
%type<v_float_list> floatvect 
%type<v_string_list> stringvect

%type<v_params> params
%type<v_parameter> intparam
%type<v_parameter> floatparam 
%type<v_parameter> stringparam 
%type<v_parameter> intlistparam
%type<v_parameter> floatlistparam
%type<v_parameter> stringlistparam 

%%

configfile:
	configfile line 
	|
	/* really empty rule */
	;
	
line: 
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_INT
	{
		if (context.checkGroupName($1)) context.sprovider.registerSource($1, $3, $5);
		else error("Invalid group name: " + $1, @1);
	}
	|
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_FLOAT
	{
		if (context.checkGroupName($1)) context.sprovider.registerSource($1, $3, $5);
		else error("Invalid group name: " + $1, @1);
	}
	|
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_STRING
	{
		if (context.checkGroupName($1)) context.sprovider.registerSource($1, $3, $5);
		else error("Invalid group name: " + $1, @1);
	}	
	|
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_LIST intlist
	{
		if (context.checkGroupName($1)) context.sprovider.registerSource($1, $3, $6);
		else error("Invalid group name: " + $1, @1);
	}	
	|
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_LIST floatlist
	{
		if (context.checkGroupName($1)) context.sprovider.registerSource($1, $3, $6);
		else error("Invalid group name: " + $1, @1);
	}	
	|
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_LIST stringlist
	{
		if (context.checkGroupName($1)) context.sprovider.registerSource($1, $3, $6);
		else error("Invalid group name: " + $1, @1);
	}	
	|
	/* command */
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_IDENTIFIER T_LEFTBRACKET params T_RIGHTBRACKET
	{
		if (context.checkGroupName($1)) {	
		     dataSourceHolder* holder = context.cprovider.create($5);
		     if (holder != NULL) {
		         holder->applyParams($7);
		     	 if	(holder->checkData()) {
			     	context.sprovider.registerSource($1, $3, holder);
			     } else {
			     	delete holder;
			     	error("Parameter integrity check failed.", @1);
				 }
		     } else {
			     error("Resource class '" + $5 + "' not found.", @1);
		     }	
		} else {
			error("Invalid group name '" + $1 + "'.", @1);
		}
	}
	|
	/* command with no parameters */
	T_IDENTIFIER T_SEPARATOR T_IDENTIFIER T_EQUALS T_IDENTIFIER T_LEFTBRACKET T_RIGHTBRACKET	
	{
		if (context.checkGroupName($1)) {	
		     dataSourceHolder* holder = context.cprovider.create($5);
		     if (holder != NULL) {
		     	 if	(holder->checkData()) {
			     	context.sprovider.registerSource($1, $3, holder);
			     } else {
			     	delete holder;
			     	error("Parameter integrity check failed.", @1);
				 }
		     } else {
			     error("Resource class '" + $5 + "' not found.", @1);
		     }	
		} else {
			error("Invalid group name '" + $1 + "'.", @1);
		}
	}
	;
	
intlist:
	T_LEFTBRACKET intvect T_COMMA T_RIGHTBRACKET
	{
		$$ = $2;
	}
	|
	T_LEFTBRACKET intvect T_RIGHTBRACKET
	{
		$$ = $2;
	}
	;
	
intvect:
	intvect T_COMMA T_INT
	{
		$$ = $1;
		$$.push_back($3);
	}
	|
	T_INT
	{
		$$.clear();
		$$.push_back($1);
	}
	;
	
floatlist:
	T_LEFTBRACKET floatvect T_COMMA T_RIGHTBRACKET
	{
		$$ = $2;
	}
	|
	T_LEFTBRACKET floatvect T_RIGHTBRACKET
	{
		$$ = $2;
	}
	;
	
floatvect:
	floatvect T_COMMA T_FLOAT
	{
		$$ = $1;
		$$.push_back($3);
	}
	|
	T_FLOAT
	{
		$$.clear();
		$$.push_back($1);
	}
	;
	
stringlist:
	T_LEFTBRACKET stringvect T_COMMA T_RIGHTBRACKET
	{
		$$ = $2;
	}
	|
	T_LEFTBRACKET stringvect T_RIGHTBRACKET
	{
		$$ = $2;
	}
	;
	
stringvect:
	stringvect T_COMMA T_STRING
	{
		$$ = $1;
		$$.push_back($3);
	}	
	|
	T_STRING
	{
		$$.clear();
		$$.push_back($1);
	}	
	;	
	
params:
	params T_COMMA intparam
	{ 
		$1.push_back($3);
		$$ = $1;
	}	
	|
	params T_COMMA floatparam
	{ 
		$1.push_back($3);
		$$ = $1;
	}	
	|
	params T_COMMA stringparam
	{ 
		$1.push_back($3);
		$$ = $1;
	}
	|
	params T_COMMA intlistparam
	{ 
		$1.push_back($3);
		$$ = $1;
	}	
	|
	params T_COMMA floatlistparam
	{ 
		$1.push_back($3);
		$$ = $1;
	}	
	|
	params T_COMMA stringlistparam
	{ 
		$1.push_back($3);
		$$ = $1;
	}	
	|
	intparam
	{
		$$.push_back($1);
	}
	|
	floatparam
	{
		$$.push_back($1);
	}
	|
	stringparam
	{
		$$.push_back($1);
	}	
	|
	intlistparam
	{
		$$.push_back($1);
	}	
	|
	floatlistparam
	{
		$$.push_back($1);
	}	
	|
	stringlistparam
	{
		$$.push_back($1);
	}	
	;
	
intparam:
	T_IDENTIFIER T_EQUALS T_INT
	{
		$$.type       = INT;
		$$.param_name = $1;
		$$.v_int      = $3;
	}	
	;	
	
floatparam:
	T_IDENTIFIER T_EQUALS T_FLOAT
	{
		$$.type       = FLOAT;
		$$.param_name = $1;
		$$.v_float    = $3;
	}	
	;	
	
stringparam:
	T_IDENTIFIER T_EQUALS T_STRING
	{
		$$.type       = STRING;
		$$.param_name = $1;
		$$.v_string	  = $3;
	}
	;
	
intlistparam:
	T_IDENTIFIER T_EQUALS T_LIST intlist
	{
		$$.type           = INTLIST;
		$$.param_name     = $1;
		$$.v_int_list     = $4;
	}	
	;	
	
floatlistparam:
	T_IDENTIFIER T_EQUALS T_LIST floatlist
	{
		$$.type           = FLOATLIST;
		$$.param_name     = $1;
		$$.v_float_list   = $4;
	}	
	;	
	
stringlistparam:
	T_IDENTIFIER T_EQUALS T_LIST stringlist
	{
		$$.type           = STRINGLIST;
		$$.param_name     = $1;
		$$.v_string_list  = $4;
	}	
	;
	
%%

static void yyerror(YYLTYPE *line, rpg_context_t& context, const char *m) {
	error(m, *line);
}
