%{
	#include <string>
	#include <stdlib.h>
	
	#include "common.h"
	#include "parser.h"
	#include "config_parser.h"

	using namespace std;
	using namespace rpg;
		
	rpg_uint_t line_number = 1;
%}

%option 8bit
%option noyywrap
%option nostdinit
%option nounistd
%option nounput
%option never-interactive

ALPHABET		[a-zA-Z]
DIGIT			[0-9]
WHITESPACE		[ \f\r\t]
IDENTIFIER_CHAR [a-zA-Z0-9\-]

%%

\n						++line_number;
\,						*line = line_number; return T_COMMA;
\(						*line = line_number; return T_LEFTBRACKET;
\)						*line = line_number; return T_RIGHTBRACKET;
list					*line = line_number; return T_LIST;
\:\:					*line = line_number; return T_SEPARATOR;
\=						*line = line_number; return T_EQUALS;

-?{DIGIT}+ {
	*line = line_number;
	errno = 0;							
	lval->v_int = strtol(yytext, (char**) NULL, 10);	
	if (errno != 0) error("Invalid number or number overflow", line_number);
	return T_INT;				
}

-?{DIGIT}+\.{DIGIT}+((e|E)-?{DIGIT}+)? {
	*line = line_number;
	errno = 0;
	lval->v_float = strtod(yytext, (char **) NULL);
	if (errno != 0) error("Invalid floating point format", line_number);
	return T_FLOAT;
}

{IDENTIFIER_CHAR}+ {
	*line = line_number;
	lval->v_string = yytext;
	return T_IDENTIFIER;								
}
						
\"[^\"]*\" {
	rpg_str_t str = yytext;
	str.erase(0,1);
	str.erase(str.length()-1,1);
	lval->v_string = str;
	return T_STRING;
}											

{WHITESPACE}+ /* do nothing */

\#[^\n]+\n ++line_number; /* comments - only increment line*/

. {
	rpg_str_t msg = "Unknown char '";
	msg += yytext;
	msg += "'";
	error(msg.c_str(), line_number);
}
