#!/usr/bin/python

from xml.sax import make_parser
from xml.sax.handler import ContentHandler
import pydot

class RPGModuleHandler (ContentHandler):

	graph = pydot.Dot(graph_type='digraph')
	modules = dict ()
	lastModuleId = None
	lastSlotId = 0
	preparationPhase = True;

	def startElement (self, name, attrs):
		if (name == 'module'):
			moduleId = attrs.get ('id', "")
			self.lastModuleId = moduleId
			self.lastSlotId = 0;

			if (self.preparationPhase):
				moduleName = attrs.get ('name', "")
				label = moduleId + '-' + moduleName
				print (label)
				node = pydot.Node (label)
				self.modules [moduleId] = node
				self.graph.add_node (node)
		elif (name == 'slot' and self.preparationPhase == False):
			targetId = attrs.get ('target-id', "")
			self.lastSlotId += 1
			self.graph.add_edge (pydot.Edge (self.modules [self.lastModuleId], self.modules [targetId], label=str (self.lastSlotId)))

parser = make_parser ()
curHandler = RPGModuleHandler ()
parser.setContentHandler (curHandler)
parser.parse (open ('main.xml'))
curHandler.preparationPhase = False;
parser.parse (open ('main.xml'))

curHandler.graph.set ('ordering', 'Out')
curHandler.graph.write_png ('main.png')
