#!/bin/bash

UTILS_DIR="$(dirname ${0})"

shared="FALSE"
if [[ ${1} == "--shared" ]]; then
    shared="TRUE"
    shift
fi

# use R to calculate the mean and sd values of isolated measurements
R --vanilla <<EOF
  source ("${UTILS_DIR}/../plot/common.R")

  tAppOutput <- readAppOutput ("${1}")
  
  tModuleIsolatedOutput <- filterIsolatedModuleMeasurements (tAppOutput)
  if (${shared}) {
    tModuleSharedOutput <- filterSharedThreadtimeModuleMeasurements (tAppOutput)
    tResults <- processModuleSharedTimes (tModuleSharedOutput, tModuleIsolatedOutput)
  } else {
    tResults <- processModuleIsolatedTimes (tModuleIsolatedOutput)
  }

  write.table (tResults, file="${2}", quote=FALSE, sep=";", row.names=FALSE)

EOF

