#!/usr/bin/python

import sys
import random

if len(sys.argv) != 4:
    print "Usage: infile outfile want_timetabled_trips"
    quit()

# open the input file
infile = open(sys.argv[1], 'r')
# the first line contains the number of timetabled trips and number of dead-head trips
counts = infile.readline().split()

# the user should want to reduce the number of timetabled trips
want_tt_trips = int(sys.argv[3])
has_tt_trips = int(counts[0])
if has_tt_trips < want_tt_trips:
    print "Too many trips specified. The input file contains only " + str(has_tt_trips)
    quit()

# the rest of the input file contains trips definition
trips = infile.readlines()
infile.close()

# first, there are definitions of timetabled trips, with given count
tt_trips = trips[0:has_tt_trips]

# we randomly choose the indexes of trips that will remain
filter_tt_trips = random.sample(range(has_tt_trips), want_tt_trips)

filter_tt_trips.sort()

# second, there are dead-head trips
dh_trips = trips[has_tt_trips:]

# these trips are defined as a triple, where two numbers refer to timetabled trips
# by their index. We will thus filter out the dead-head trips that refer to filtered
# out timetabled trips.
# We also have to renumber the unfiltered trips, as the unfiltered timetabled trips
# will have different index in the resultng files.
filtered_dh_trips = []
for trip in dh_trips:
    tokens = trip.split()
    # mfc starts at 1, python at 0
    tt_start = int(tokens[0]) - 1
    tt_end = int(tokens[1]) - 1
    # proceed only if both were not filtered
    if tt_start in filter_tt_trips and tt_end in filter_tt_trips:
        # find the new indexes of these trips
	new_tt_start = filter_tt_trips.index(tt_start) + 1
	new_tt_end = filter_tt_trips.index(tt_end) + 1
	filtered_dh_trips.append(str(new_tt_start) + " " + str(new_tt_end) + " " + tokens[2] + "\n")

# now we can write the output
outfile = open(sys.argv[2], 'w+')

# first line are the new numbers of timetabled and dead-head trips
outfile.write(str(want_tt_trips) + " " + str(len(filtered_dh_trips)) + "\n")

# then the timetabled trips
for i in filter_tt_trips:
    outfile.write(tt_trips[i])

# then the dead-head trips
outfile.writelines(filtered_dh_trips)

outfile.close()
