#!/usr/bin/python

from xml.sax import make_parser
from xml.sax.handler import ContentHandler

class RPGModuleHandler (ContentHandler):

	modules = dict ()
	lastModuleId = None
	lastSlotId = 0
	preparationPhase = True;
	rootModuleId = None
	depths = dict ()

	def startElement (self, name, attrs):
		if (name == 'module'):
			moduleId = attrs.get ('id', "")
			self.lastModuleId = moduleId
			self.lastSlotId = 0;

			if (self.preparationPhase):
				moduleName = attrs.get ('name', "")
				label = moduleId + '-' + moduleName
				self.modules [moduleId] = set ()
		elif (name == 'slot' and self.preparationPhase == False):
			targetId = attrs.get ('target-id', "")
			self.lastSlotId += 1
			self.modules [self.lastModuleId].add (targetId)
		elif (name == 'architecture'):
			self.rootModuleId = attrs.get ('root-module-id', "")
	
	def calculateDepths (self):
		self.depthsFromModule (self.rootModuleId, 0)

	def depthsFromModule (self, moduleId, parentDepth):
		myDepth = parentDepth + 1
		self.depths [moduleId] = myDepth
		for mod in self.modules [moduleId]:
			self.depthsFromModule (mod, myDepth)

parser = make_parser ()
curHandler = RPGModuleHandler ()
parser.setContentHandler (curHandler)

parser.parse (open ('main.xml'))
curHandler.preparationPhase = False;
parser.parse (open ('main.xml'))

curHandler.calculateDepths()
print ('maxDepth;' + str (max (curHandler.depths.values())))
print ('meanDepth;' + str (float (sum (curHandler.depths.values())) / len (curHandler.depths)))
