#! /usr/bin/awk -f

function getVal(s,       ar) {
	split(s, ar, "=");
	return ar[2];
}

function printVal(s,	ar) {
	split(s, ar, "=");
	print placeType, placeName, "Color" color, ar[1], ar[2]
}

BEGIN {
	placeType = "";
	placeName = "";
	color = "";
	OFS = "\t";
}

# Comments, empty lines and general values outside block -> ignore

block == 0 && (/^#/ || /^$/ || /^V / || /^C / || /^I / || /^PP / || /^NP / || /^N /) {
	next;
}

/^REPORT for/ {
	placeType = $3;
	gsub("-*", "", $5);
	placeName = $5;
	next;
}

/^------------------ Color=/ {
	gsub("Color=", "", $2);
	color = $2;
	next;
}

/^arrivCnt=/ {
	printVal($1);
	printVal($2);
}

/^arrivThrPut=/ {
	printVal($1);
	printVal($2);
}

/^meanTkPop=/ {
	printVal($1);
	printVal($2);
}

/^meanST=/ {
	printVal($1);
	printVal($2);
}

{
	next;
}
