#!/bin/bash

# This plot summarizes measurements of all individual modules into a big boxplot
# There are two boxplots per each module
# - isolated measurements (black)
# - thread-time measurements ~ CPU time spent in a module during execution of full system (red)

# All values are normalized per module, as a ratio to the mean *isolated* execution time.
# This allows having all modules on a same scale and quickly see if some exhibits a significant relative slowdown
# The variability (box height) thus becomes also relative.

SCRIPTS_DIR="$(dirname ${0})"

R -q --no-save --no-restore <<EOF
  source("${SCRIPTS_DIR}/plot.R", chdir=TRUE)

  sFile="lStats.Rdata"

  # cache to save time when tweaking the plots
  # delete lStats.Rdata when the data itself or the stats gathering changes
  if (file.exists(sFile)) {
    load (sFile)
  } else {
    
    lStats <- getStatsAcrossArchitectures ("")
    save (lStats, file=sFile)
  }

  #lStats <- lStats

  png("scatter-modules-svctimes.png", width=1024, height=768)

  plotScatterModulesCountVsSvcTimeSlowdown (lStats)

  dev.off()

  plotSeparateModulesScatterCPUUtilVsSvcTimeSlowdown (lStats)   

  png("scatter-sim-cpuutil-svctimes.png", width=1024, height=768)
  #postscript("scatter-sim-cpuutil-svctimes.ps", width=8.27, height=5.83, horizontal=FALSE)

  plotScatterCPUUtilVsSvcTimeSlowdown (lStats)

  dev.off()

  plotBarplotModuleCounts (lStats)

EOF

