#!/bin/bash

# This script plots all graphs for a single run of app and associated simulations

SCRIPTS_DIR="$(dirname ${0})"

if [[ ! -f main.out ]]; then
  echo "App output (main.out) not found, cannot plot anything."
  exit 1
fi

${SCRIPTS_DIR}/plot-modules.sh
${SCRIPTS_DIR}/plot-app.sh

if [[ -f sim.out || -f sim.out.raw ]]; then
  ${SCRIPTS_DIR}/plot-app-sim.sh
else
  echo "SimQPN simulation output (sim.out) not found, skipping its plots."
fi

if [[ -f main.csv ]]; then
  ${SCRIPTS_DIR}/plot-app-pcm.sh
else
  echo "PCM simulation output (main.csv) not found, skipping its plots."
fi

