#!/bin/bash

# This plot summarizes measurements of all individual modules into a big boxplot
# There are two boxplots per each module
# - isolated measurements (black)
# - thread-time measurements ~ CPU time spent in a module during execution of full system (red)

# All values are normalized per module, as a ratio to the mean *isolated* execution time.
# This allows having all modules on a same scale and quickly see if some exhibits a significant relative slowdown
# The variability (box height) thus becomes also relative.

SCRIPTS_DIR="$(dirname ${0})"

R -q --no-save --no-restore <<EOF
  source("${SCRIPTS_DIR}/plot.R", chdir=TRUE)

  tAppOutput <- readAppOutput ("main.out")

  png("modules.png", width=1024, height=768)

  plotModuleMeasurements (tAppOutput, FALSE)

  dev.off()
EOF

