#!/bin/bash

# This script plots trends of throughput and response times with increasing number of clients

SCRIPTS_DIR="$(dirname ${0})"

sim="TRUE"
cl=$(head -n 1 clients.list)
if [[ ! -f sim-clients-${cl}.out && ! -f sim-clients-${cl}.out.bz2 ]]; then
  sim="FALSE"
fi

pcm="FALSE"
if [[ -n ${1} ]]; then
  pcmSubDir="${1}"
  pcm="TRUE"
fi

R -q --no-save --no-restore <<EOF
  source ("${SCRIPTS_DIR}/plot.R", chdir=TRUE)

  vClients <- readClients ()

#   png ("response-trend-clients.png", width=1024, height=768)

#   plotResponseTimeTrends (vClients)

#   dev.off ()

  png ("throughput-trend-clients.png", width=1024, height=768)

  plotThrputTrends (vClients, bSim=${sim}, bPCM=${pcm}, sPCMSubDir="${pcmSubDir}")

  dev.off ()

EOF

