#!/bin/bash

# This script plots response times and througput of the generated app

SCRIPTS_DIR="$(dirname ${0})"

R -q --no-save --no-restore <<EOF
  source ("${SCRIPTS_DIR}/plot.R", chdir=TRUE)

  tAppOutput <- readAppOutput ("main.out")

  tAppTimes <- getAppTimes (tAppOutput)

  png ("response.png", width=1024, height=768)

  plotAppResponseTimes (tAppTimes)

  dev.off ()

  png ("response-thread.png", width=1024, height=768)

  plotAppThreadResponseTimes (tAppTimes)

  dev.off ()

#   png ("throughput.png", width=1024, height=768)

#   plotAppThrput (tAppTimes)

#   dev.off ()

#   png ("finishdelta.png", width=1024, height=768)
# 
#   plotAppFinishTimes (tAppTimes)
# 
#   dev.off ()

EOF

