#!/bin/bash

# This script plots summary of app throughput and response time together with SimQPN mean values for comparison

SCRIPTS_DIR="$(dirname ${0})"

SIM_RAW="sim.out.raw"
SIM_OUT="sim.out"

SIM_EXP_RAW="sim-exp.log"
SIM_EXP_OUT="sim-exp.out"

SIM_NOR_RAW="sim-nor.log"
SIM_NOR_OUT="sim-nor.out"

PCM_OUT="main.csv"

# convert SimQPN raw output to simpler form
# "${SCRIPTS_DIR}"/simqpn-output-parser.awk "${SIM_EXP_RAW}" > "${SIM_EXP_OUT}"
# "${SCRIPTS_DIR}"/simqpn-output-parser.awk "${SIM_NOR_RAW}" > "${SIM_NOR_OUT}"
if [[ ! -f ${SIM_OUT} || ${SIM_RAW} -nt ${SIM_OUT} ]]; then
  [[ -f ${SIM_RAW} ]] && "${SCRIPTS_DIR}"/simqpn-output-parser.awk "${SIM_RAW}" > "${SIM_OUT}"
fi

if [[ ! -f ${SIM_OUT} ]]; then
  echo "Error: ${SIM_OUT} not found!"
  exit 1
fi

R -q --no-save --no-restore <<EOF
  source ("${SCRIPTS_DIR}/plot.R", chdir=TRUE)

  tAppOutput <- readAppOutput ("main.out")

#   tSimExpOutput <- readSimQPNOutput ("${SIM_EXP_OUT}")
# 
#   tSimNorOutput <- readSimQPNOutput ("${SIM_NOR_OUT}")

  tSimOutput <- readSimQPNOutput ("${SIM_OUT}")

  if (file.exists ("${PCM_OUT}")) {
    tPCMOutput <- readPCMOutput ("${PCM_OUT}")
  } else {
    tPCMOutput <- NULL
  }

  png ("response-mean.png", width=1024, height=768)

#   plotMeanResponseTimes (tAppOutput, tSimExpOutput, tSimNorOutput)

  plotMeanResponseTimes (tAppOutput, tSimOutput, NULL, tPCMOutput)

  dev.off ()

  png ("throughput-mean.png", width=1024, height=768)

#   plotMeanThrputs (tAppOutput, tSimExpOutput, tSimNorOutput)

  plotMeanThrputs (tAppOutput, tSimOutput, NULL, tPCMOutput)

  dev.off ()

EOF

