#!/bin/bash

# This script plots histograms and densities of client response times measured and predicted by PCM

SCRIPTS_DIR="$(dirname ${0})"

R -q --no-save --no-restore <<EOF
  source ("${SCRIPTS_DIR}/plot.R", chdir=TRUE)

  tAppOutput <- readAppOutput ("main.out")

  tPCMOutput <- readPCMOutput ("main.csv")

  png ("response-pcm.png", width=1024, height=768)

  plotPCMResponseTimes (tPCMOutput)

  dev.off ()

  png ("response-app-pcm-dens.png", width=1024, height=768)

  plotAppPCMResponseTimesDensity (tAppOutput, tPCMOutput)

  dev.off ()

  png ("response-app-pcm-hist.png", width=1024, height=768)

  plotAppPCMResponseTimesHist (tAppOutput, tPCMOutput)

  dev.off ()

EOF

