#!/bin/bash

RPG_LANG="cpp"

# determine the ROOT_DIR
. $(dirname ${0})/internal-generate-shared.sh

cd ${ROOT_DIR}/bin

# generate the special measurement architecture
rm -rf measure
./generate-architecture-cpp.sh measure-expected-durations measure

# run the isolated measurements
cd measure
./main | tee main.out

# extract module names from main.xml so that R can read them
${ROOT_DIR}/bin/utils/parse-modules.py main.xml > modules.out

# use R to calculate the mean values
R --vanilla <<EOF
  source ("${ROOT_DIR}/bin/plot/common.R")

  tAppOutput <- readAppOutput ("main.out")

  tModules <- readModuleClassFile ("modules.out")

  tResults <- getModuleNameIsolatedTimes (tAppOutput, tModules)
  
  unlink ("${ROOT_DIR}/bin/conf/cpp/expected-durations.conf")
  
  printModuleExpectedDurations (tResults, "${ROOT_DIR}/bin/conf/cpp/expected-durations.conf")

EOF

