#!/bin/bash
set -e

# Generates includes for a random architecture.

RPG_LANG="cpp"
. $(dirname ${0})/internal-generate-shared.sh

echo ${ROOT_DIR}

DATA_DIR=${ROOT_DIR:?}/src/include

# Generate an include file that includes all module includes (wow, what a sentence :-).

(
  for MODULE in ${ROOT_DIR:?}/src/modules/cpp/*
  do
    if [[ -f "${MODULE:?}/_module.h" ]]
    then
      echo "#include \"$(basename ${MODULE:?})/_module.h\""
    fi 
  done
) > "${DATA_DIR:?}/modules.h"
