/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.jsf.beans;

import java.io.Serializable;
import java.util.Date;

import javax.faces.event.ActionEvent;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters;
import de.itemis.qimpress.showcase.simulation_manager.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.simulation_manager.be.service.ServiceLocator;
import de.itemis.qimpress.showcase.simulation_manager.be.service.SimulationManager;

/**
 * The SimulationManagerTimeDataController class controls communication between
 * frontend and backend.
 * @author Claudius Haecker
 */
public class SimulationManagerTimeDataController implements Serializable {
    //    public static final String START = "start";
    //    public static final String STOP = "stop";
    //    public static final String RUN_MODIFIED = "run_modified";
    //    public static final String STOP_MODIFIED = "stop_modified";

    private static final long serialVersionUID = 2661512647833730177L;
    private static final Logger LOG = Logger.getLogger(SimulationManagerTimeDataController.class);
    private SimulationManager simulationManager = ServiceLocator.getInstance().getSimulationManager();
    //    private boolean actionWasSuccess;
    //    private String action = STOP;
    private SimulationManagerFeController simulationManagerController;
    private TimeParameters timeParameters;

    /**
     * constructor for the SimulationManagerFeController.
     * The constructor instanciates the simulationManager
     */
    public SimulationManagerTimeDataController() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating SimulationManagerTimeDataController");
        }
        if (simulationManager == null) {
            LOG.error("simulationManager from ServiceLocater was null");
            throw new IllegalStateException("Could not configure simulationManager.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("simulationManager = " + simulationManager);
        }
        try {
            timeParameters = simulationManager.loadTimeParameters();
        } catch (ApplicationException ae) {
            LOG.error("Could not load time parameters", ae);
        }
    }

    /**
     * @return whether we use simulated Time
     */
    public boolean isSimulatedTime() {
        return timeParameters.getGeneratorTimeMode() == TimeParameters.GeneratorTimeMode.SIMULATED_TIME;
    }

    /**
     * @return the timeParameters
     */
    public TimeParameters getTimeParameters() {
        return timeParameters;
    }

    public String getDummy() {
        return "";
    }

    /**
     * Is called when the user presses the start-generator button.
     * @param event ignored
     */
    public void saveParameters(ActionEvent event) {
        try {
            simulationManager.saveTimeParameters(timeParameters);
        } catch (ApplicationException ae) {
            LOG.error("Could not save parameters TimeScaleFactor:" + timeParameters.getTimeScaleFactor()
                    + " StartTimeForOrders: " + timeParameters.getStartTimeForOrders(), ae);
        }
        //        if (STOP.equals(action) || (STOP_MODIFIED.equals(action))) {
        //            action = STOP_MODIFIED;
        //        } else {
        //            action = RUN_MODIFIED;
        //        }
        //        actionHistory.add(new Action(action, new Date()));
    }

    /**
     * Is called when the user presses the start-generator button.
     * @param event ignored
     */
    public void startSimulators(ActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> startGenerator()");
        }
        try {
            if (simulationManager.startSimulators(getTimeParameters())) {
                simulationManagerController.getActionHistory().add(
                        new Action(SimulationManagerFeController.START, new Date()));
            }
        } catch (ApplicationException e) {
            LOG.error("Could not start simulators", e);
        }
    }

    /**
     * Is called when the user presses the stop-generator button.
     * @param event ignored
     */
    public void stopSimulators(ActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> stopGenerator()");
        }
        try {
            if (simulationManager.stopSimulators()) {
                simulationManagerController.getActionHistory().add(
                        new Action(SimulationManagerFeController.STOP, new Date()));
            }
        } catch (ApplicationException ae) {
            LOG.error("Could not stop Simulators", ae);
        }
    }

    /**
     * @param simulationManagerController the simulationManagerController to set
     */
    public void setSimulationManagerController(SimulationManagerFeController simulationManagerController) {
        this.simulationManagerController = simulationManagerController;
    }
}
