/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.jsf.beans;

import java.io.Serializable;
import java.util.ArrayList;


import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.simulation_manager.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.simulation_manager.be.service.ServiceLocator;
import de.itemis.qimpress.showcase.simulation_manager.be.service.SimulationManager;

/**
 * The SimulationManagerFeController class controls communication between
 * frontend (the control panel) and backend.
 * @author Claudius Haecker
 */
public class SimulationManagerFeController implements Serializable {

    private static final long serialVersionUID = 3411175624659037944L;
    private static final Logger LOG = Logger.getLogger(SimulationManagerFeController.class);
    public static final String START = "start";
    public static final String STOP = "stop";
//    public static final String RUN_MODIFIED = "run_modified";
//    public static final String STOP_MODIFIED = "stop_modified";
    private static final SimulationManager SIMULATOR_MANAGER = ServiceLocator.getInstance().getSimulationManager();
    private ArrayList<Action> actionHistory = new ArrayList<Action>();
    private boolean actionWasSuccess;
    // timeParameters are injected by the request-scoped SimulationManagerTimeDataController

    /**
     * constructor for the SimulationManagerFeController.
     * The constructor instanciates the SIMULATOR_MANAGER
     */
    public SimulationManagerFeController() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  SimulationManagerFeController");
        }
        if (SIMULATOR_MANAGER == null) {
            LOG.error("SIMULATOR_MANAGER from ServiceLocater was null");
            throw new IllegalStateException("Could not configure SIMULATOR_MANAGER.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("SIMULATOR_MANAGER = " + SIMULATOR_MANAGER);
        }
    }

    /**
     * @return the actionHistory
     */
    public ArrayList<Action> getActionHistory() {
        return actionHistory;
    }

    /**
     * @param actionHistory the actionHistory to set
     */
    public void setActionHistory(ArrayList<Action> actionHistory) {
        this.actionHistory = actionHistory;
    }

    /**
    * Constructor
    */
    //    public SimulationManagerFeController() {
    //        globalParameters = new GlobalParameters("c:\\", 500, 1.0f, 0.5f, Arrays.asList(
    //                new CustomerTypeParameters("private", 3, 30, 5, 50), new CustomerTypeParameters("business", 13, 130,
    //                        15, 150)));
    //    }
    /**
     * @return the actionWasSuccess
     */
    public boolean isActionWasSuccess() {
        return actionWasSuccess;
    }

    /**
     * @return whether the order generator is running
     */
    public boolean isOrderSimulatorRunning() {
        try {
            return SIMULATOR_MANAGER.isOrderSimulatorRunning();
        } catch (ApplicationException ae) {
            LOG.error("Error getting running-state", ae);
        }
        return false;
    }

    //    /**
    //     * @param generatorTimeMode generator time mode: "simulated time" or "real time"
    //     */
    //    public void setGeneratorTimeMode(String generatorTimeMode) {
    //        // throw new IncompatibleClassChangeError();
    //        globalParameters
    //                .setGeneratorTimeMode(Enum.valueOf(GlobalParameters.GeneratorTimeMode.class, generatorTimeMode));
    //    }
}
