/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.jsf.beans;

import org.apache.log4j.Logger;

import com.icesoft.faces.async.render.OnDemandRenderer;
import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.context.DisposableBean;
import com.icesoft.faces.webapp.xmlhttp.FatalRenderingException;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;

/**
 * @author Claudius Haecker
 *
 */
public class RunningStatusDisplayController implements Renderable, DisposableBean {

    private static final Logger LOG = Logger.getLogger(RunningStatusDisplayController.class);

    // for each user one jspx is active, and each user is represented by ONE PersistentFacesState instance
    private PersistentFacesState state;
    private RenderManager renderManager;
    private OnDemandRenderer simulatorsStatusGroup;
    private StatusPoller statusPoller;

    /**
     *
     */
    public RunningStatusDisplayController() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating RunningStatusDisplayController");
        }
        state = PersistentFacesState.getInstance();
    }

    public PersistentFacesState getState() {
        return state;
    }

    public void renderingException(RenderingException renderingException) {
        //Logic for handling rendering exceptions can differ depending 
        //on the application. Here if we have a problem, we'll just remove
        //our Renderable from the render group so that there are no further
        //attempts to render this user.
        simulatorsStatusGroup.remove(this);
        // more tolerant:
        //        if (renderingException instanceof FatalRenderingException) {
        //            simulatorsStatusGroup.remove(this);
        //        }
    }

    /**
     * See <a href="advanced_topics2.html#1056220">Server-initiated Rendering API </a>
     * @param renderManager
     */
    public void setRenderManager(RenderManager renderManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> setRenderManager");
        }
        this.renderManager = renderManager;
        simulatorsStatusGroup = renderManager.getOnDemandRenderer("simulatorsStatus");
        simulatorsStatusGroup.add(this);
    }

    public void dispose() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disposing RunningStatusDisplayController");
        }
        simulatorsStatusGroup.remove(this);
    }

    /**
     * @param statusPoller the statusPoller to set
     */
    public void setStatusPoller(StatusPoller statusPoller) {
        this.statusPoller = statusPoller;
    }

    /**
     * @return true, if Order Simulator was running during the last check
     */
    public boolean isOrderSimulatorRunning() {
        return statusPoller.isOrderSimulatorRunning();
    }

    /**
     * @return true, if Shipment Simulator was running during the last check
     */
    public boolean isShipmentSimulatorRunning() {
        return statusPoller.isShipmentSimulatorRunning();
    }
}
