/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.jsf.beans;

import static javax.faces.event.PhaseId.ANY_PHASE;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import org.apache.log4j.Logger;

/**
 *@author Claudius Haecker 
 */

public class PhaseTracker implements PhaseListener {

    private static final Logger LOG = Logger.getLogger(PhaseTracker.class);

    /* (non-Javadoc)
     * @see javax.faces.event.PhaseListener#getPhaseId()
     */
    public PhaseId getPhaseId() {
        return ANY_PHASE;
    }

    public void beforePhase(PhaseEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("BEFORE " + e.getPhaseId());
        }
    }

    public void afterPhase(PhaseEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("AFTER " + e.getPhaseId());
        }
    }
}
