/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.tests.be;

import static org.junit.Assert.*;

import java.util.Date;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters;
import de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters.GeneratorTimeMode;
import de.itemis.qimpress.showcase.simulation_manager.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.simulation_manager.be.service.ServiceLocator;
import de.itemis.qimpress.showcase.simulation_manager.be.service.SimulationManager;

/**
 * JUnit test class for
 * {@link de.itemis.qimpress.showcase.simulation_manager.be.service.SimulationManager}.
 * 
 * @author Wladimir Safonov
 *
 */
public class SimulationManagerTest {

    private static final Logger LOG = Logger.getLogger(SimulationManagerTest.class);

    private static SimulationManager SIMULATION_MANAGER = ServiceLocator.getInstance().getSimulationManager();

    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called initTestSuite()");
        }

        
        assertNotNull("Failed to locate SimulationManager instance over ServiceLocator: result is null",
                SIMULATION_MANAGER);
    }

    @Test
    public void testLoadParameters() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }

        TimeParameters timeParameters = null;
        try {
            timeParameters = SIMULATION_MANAGER.loadTimeParameters();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to load TimeParameters");
        }
        assertNotNull("Failed to load TimeParameters: result is null", timeParameters);
        assertNotNull("Failed to load TimeParameters: timeMode is null", timeParameters.getGeneratorTimeMode());
        assertNotNull("Failed to load TimeParameters: startTimeForOrders is null", timeParameters
                .getStartTimeForOrders());
        assertTrue("Failed to load TimeParameters: timeScaleFactor is 0.0", timeParameters.getTimeScaleFactor() != 0.0f);
    }

    @Test
    public void testStoreParameters() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }

        TimeParameters timeParameters = new TimeParameters();
        timeParameters.setGeneratorTimeMode(GeneratorTimeMode.REAL_TIME);
        timeParameters.setStartTimeForOrders(new Date());
        timeParameters.setTimeScaleFactor(11.0f);

        try {
            SIMULATION_MANAGER.saveTimeParameters(timeParameters);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to store TimeParameters");
        }
    }

    @Test
    public void testOrderSimulatorStartStop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testOrderSimulatorStartStop()");
        }

        TimeParameters timeParameters = new TimeParameters();
        timeParameters.setGeneratorTimeMode(GeneratorTimeMode.REAL_TIME);
        timeParameters.setStartTimeForOrders(new Date());
        timeParameters.setTimeScaleFactor(11.0f);

        // check initial status
        boolean isOrderSimulatorRunning = false, isShipmentSimulatorRunning = false;
        try {
            isOrderSimulatorRunning = SIMULATION_MANAGER.isOrderSimulatorRunning();
            isShipmentSimulatorRunning = SIMULATION_MANAGER.isShipmentSimulatorRunning();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to get Order/Shipment Simulator status");
        }
        assertFalse("Order Simulator is expected to be in stopped mode", isOrderSimulatorRunning);
        assertFalse("Shipment Simulator is expected to be in stopped mode", isShipmentSimulatorRunning);

        // start simulators
        boolean areStarted = false;
        try {
            areStarted = SIMULATION_MANAGER.startSimulators(timeParameters);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to start Simulators");
        }
        assertTrue("Failed to start Simulators: result is false", areStarted);

        // wait for a bit
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        // check status
        try {
            isOrderSimulatorRunning = SIMULATION_MANAGER.isOrderSimulatorRunning();
            isShipmentSimulatorRunning = SIMULATION_MANAGER.isShipmentSimulatorRunning();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to get Order/Shipment Simulator status");
        }
        assertTrue("Order Simulator is expected to be in running mode", isOrderSimulatorRunning);
        assertTrue("Shipment Simulator is expected to be in running mode", isShipmentSimulatorRunning);

        // stop simulators
        boolean areStopped = false;
        try {
            areStopped = SIMULATION_MANAGER.stopSimulators();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to stop Simulators");
        }
        assertTrue("Failed to stop Simulators: result is false", areStopped);
    }

}
