/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.be.service;

import de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters;
import de.itemis.qimpress.showcase.simulation_manager.be.exceptions.ApplicationException;

/**
 * Configuration and controlling interface of the Simulation Manager
 * application. Allows to load/save simulation time parameters and
 * to start/stop simulator systems (Order Simulator and Shipment Simulator).
 * 
 * @author Wladimir Safonov
 *
 */
public interface SimulationManager {

    /**
     * Starts both simulation systems (Order Simulator and Shipment Simulator) 
     * with the given simulation time parameters.
     * 
     * @param timeParameters simulation time parameters
     * @return true if succeeded
     * @throws ApplicationException in case of a remote system failure
     */
    public boolean startSimulators(TimeParameters timeParameters) throws ApplicationException;
    
    /**
     * Stops both simulation systems (Order Simulator and Shipment Simulator).
     * 
     * @return true if succeeded
     * @throws ApplicationException in case of a remote system failure
     */
    public boolean stopSimulators() throws ApplicationException;
    
    /**
     * Checks the status of the Order Simulator.
     * 
     * @return true if the order simulator is running
     * @throws ApplicationException in case of a remote system failure
     */
    public boolean isOrderSimulatorRunning() throws ApplicationException;
    
    /**
     * Checks the status of the Shipment Simulator.
     * 
     * @return true if the shipment simulator is running
     * @throws ApplicationException in case of a remote system failure
     */
    public boolean isShipmentSimulatorRunning() throws ApplicationException;
    
    /**
     * Loads time 
     * {@link de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters parameters}
     * for the simulation.
     * 
     * @return simulation time 
     * {@link de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters parameters}
     * @throws ApplicationException in case of a database failure
     */
    public TimeParameters loadTimeParameters() throws ApplicationException;
    
    /**
     * Saves simulation time parameters. Operation is allowed only 
     * if the simulation systems are not running at the moment.
     * 
     * @param timeParameters simulation time parameters
     * @return true if succeeded
     * @throws ApplicationException in case of a database failure
     */
    public boolean saveTimeParameters(TimeParameters timeParameters) throws ApplicationException;
    
}
