/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.be.domain;

import java.util.Date;


/**
 * Class holding time parameters for the simulator systems.
 * 
 * @author Wladimir Safonov
 *
 */
public class TimeParameters {

    /** time mode of the order generator */
    private GeneratorTimeMode generatorTimeMode;
    /** starting time for the generated orders dates */
    private Date startTimeForOrders;
    /** scale factor for calculating generated orders dates (only valid for simulated time mode) */
    private float timeScaleFactor;

    
    /**
     * Getter for the time mode of the order generator
     * 
     * @return the generatorTimeMode
     */
    public GeneratorTimeMode getGeneratorTimeMode() {
        return generatorTimeMode;
    }

    /**
     * Setter for the time mode of the order generator
     * 
     * @param timeMode the generatorTimeMode to set
     */
    public void setGeneratorTimeMode(GeneratorTimeMode timeMode) {
        this.generatorTimeMode = timeMode;
    }

    /**
     * Getter for the starting time for the generated orders dates
     * 
     * @return the startTimeForOrders
     */
    public Date getStartTimeForOrders() {
        return startTimeForOrders;
    }

    /**
     * Setter for the starting time for the generated orders dates
     * 
     * @param startTimeForOrders the startTimeForOrders to set
     */
    public void setStartTimeForOrders(Date startTimeForOrders) {
        this.startTimeForOrders = startTimeForOrders;
    }

    /**
     * Getter for the scale factor for calculating generated orders dates
     * 
     * @return the timeScaleFactor
     */
    public float getTimeScaleFactor() {
        return timeScaleFactor;
    }

    /**
     * Setter for the scale factor for calculating generated orders dates
     * 
     * @param timeScaleFactor the timeScaleFactor to set
     */
    public void setTimeScaleFactor(float timeScaleFactor) {
        this.timeScaleFactor = timeScaleFactor;
    }


    /**
     * Enum for the generators time mode. 
     * Represents modes for the real time and for a simulated time.
     * 
     * @author Wladimir Safonov
     * 
     */
    public enum GeneratorTimeMode {

        REAL_TIME, SIMULATED_TIME
    }
}
