/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.simulation_manager.be.dao;

import de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters;
import de.itemis.qimpress.showcase.simulation_manager.be.exceptions.DaoException;

/**
 * DAO-operations interface for loading/storing simulation parameters 
 * (e.g. {@link de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters}).
 * 
 * @author Wladimir Safonov
 *
 */
public interface ParametersDao {

    /**
     * Loads stored 
     * {@link de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters}
     * from the database.
     * 
     * @return stored
     * {@link de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters}
     * @throws DaoException in case of a database failure
     */
    TimeParameters loadTimeParameters() throws DaoException;
    
    /**
     * Stored the given
     * {@link de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters}
     * in the database.
     * 
     * @param timeParameters 
     * {@link de.itemis.qimpress.showcase.simulation_manager.be.domain.TimeParameters}
     * to store in the database
     * @throws DaoException in case of a database failure
     */
    void storeTimeParameters(TimeParameters timeParameters) throws DaoException;
}
