/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.webservice.mock;

import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.ws.server.endpoint.AbstractJDomPayloadEndpoint;

/**
 * @author Wladimir Safonov
 *
 */
public class MockShipmentSimulatorJDomEndpoint extends AbstractJDomPayloadEndpoint {

    private static final Logger LOG = Logger.getLogger(MockShipmentSimulatorJDomEndpoint.class);
    
    private static final String START_SHIPMENT_SIMULATOR_REQUEST = "StartShipmentSimulatorRequest";
    private static final String START_SHIPMENT_SIMULATOR_RESPONSE = "StartShipmentSimulatorResponse";
    private static final String STOP_SHIPMENT_SIMULATOR_REQUEST = "StopShipmentSimulatorRequest";
    private static final String STOP_SHIPMENT_SIMULATOR_RESPONSE = "StopShipmentSimulatorResponse";
    private static final String GET_SHIPMENT_SIMULATOR_STATUS_REQUEST = "GetShipmentSimulatorStatusRequest";
    private static final String GET_SHIPMENT_SIMULATOR_STATUS_RESPONSE = "GetShipmentSimulatorStatusResponse";
    
    private static final String STATUS_RUNNING = "RUNNING";
    private static final String STATUS_STOPPED = "STOPPED";
    
    private Namespace namespace;
    
    private boolean isSimulatorRunning = false;
    
    public MockShipmentSimulatorJDomEndpoint() {
        super();
        namespace = Namespace.getNamespace("ss", "http://www.itemis.com/shipment_simulator/schemas");
    }

    @Override
    protected Element invokeInternal(Element request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> invokeInternal()");
        }
        
        String rootElement = request.getName();
        if (START_SHIPMENT_SIMULATOR_REQUEST.equals(rootElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected root element: " + START_SHIPMENT_SIMULATOR_REQUEST);
            }
            
            return processStartShipmentSimulatorRequest(request);
        } else if (STOP_SHIPMENT_SIMULATOR_REQUEST.equals(rootElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected root element: " + STOP_SHIPMENT_SIMULATOR_REQUEST);
            }
            
            return processStopShipmentSimulatorRequest(request);
        } else if (GET_SHIPMENT_SIMULATOR_STATUS_REQUEST.equals(rootElement)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected root element: " + GET_SHIPMENT_SIMULATOR_STATUS_REQUEST);
            }
            
            return processGetShipmentSimulatorStatusRequest(request);
        }
        return null;
    }
    
    protected Element processStartShipmentSimulatorRequest(Element request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> processStartShipmentSimulatorRequest()");
        }
        
        // start order generator
        isSimulatorRunning = true;
        
        // create response element
        Element response = new Element(START_SHIPMENT_SIMULATOR_RESPONSE, namespace);
        Element result = new Element("StartResult", namespace).setText(Boolean.toString(isSimulatorRunning));
        response.addContent(result);
        
        return response;
    }
    
    protected Element processStopShipmentSimulatorRequest(Element request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> processStopShipmentSimulatorRequest()");
        }
        
        // stop order generator
        isSimulatorRunning = false;
        
        // create response element
        Element response = new Element(STOP_SHIPMENT_SIMULATOR_RESPONSE, namespace);
        Element result = new Element("StopResult", namespace).setText(Boolean.toString(isSimulatorRunning));
        response.addContent(result);
        
        return response;
    }
    
    protected Element processGetShipmentSimulatorStatusRequest(Element request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> processGetShipmentSimulatorStatusRequest()");
        }
        
        // create response element
        Element response = new Element(GET_SHIPMENT_SIMULATOR_STATUS_RESPONSE, namespace);
        Element result = new Element("StatusResult", namespace).setText(isSimulatorRunning ? STATUS_RUNNING : STATUS_STOPPED);
        response.addContent(result);
        
        return response;
    }
}
