/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.jsf.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.naming.NamingException;

import org.apache.log4j.Logger;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.ShippingState;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.ServiceLocator;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;

/**
 * The ShipmentSimulatorFeController class controls communication between
 * frontend and backend.
 * @author Claudius Haecker
 */
public class ShipmentSimulatorFeController implements Serializable {

    private static final Logger LOG = Logger.getLogger(ShipmentSimulatorFeController.class);
    private static final ShipmentSimulatorManager SHIPMENT_SIMULATOR_MANAGER = ServiceLocator.getInstance()
            .getShipmentSimulatorManager();
    private GlobalParameters globalParameters;

    private boolean orderFound;

    private List<Shipment> shipments = new ArrayList<Shipment>();

    /**
     * @return the shipments
     */
    public List<Shipment> getShipments() {
        return shipments;
    }

    private OrderShipping orderShipping;

    private ShippingState shippingState = null;
    private String customerNumber = "";
    private String orderNumber = "";

    //    private String trackingCode = "";
    //    private Date dispatchDate = new Date();

    //    private String action = STOP;

    /**
     * constructor for the ShipmentSimulatorFeController.
     * The constructor instanciates the osgAppManager
     */
    public ShipmentSimulatorFeController() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>  ShipmentSimulatorFeController");
        }
        if (SHIPMENT_SIMULATOR_MANAGER == null) {
            LOG.error("osgAppManager from ServiceLocater was null");
            throw new IllegalStateException("Could not configure osgAppManager.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("osgAppManager = " + SHIPMENT_SIMULATOR_MANAGER);
        }
        try {
            globalParameters = SHIPMENT_SIMULATOR_MANAGER.loadShipmentGeneratorParameters();
        } catch (ApplicationException ae) {
            LOG.error("Could not loadShipmentGeneratorParameters", ae);
            // TODO (MH) Read error code and trigger FE error handling
        }
    }

    /**
     * Via the globalParameters all parameters are set and read by the frontend except for the customerTypeParameters.
     * @return the globalParameters
     */
    public GlobalParameters getGlobalParameters() {
        return globalParameters;
    }

    /**
     * Is called when the user presses the set-parameters button.
     * @param event ignored
     */
    public void saveGlobalParameters(ActionEvent event) {
        try {
            SHIPMENT_SIMULATOR_MANAGER.saveShipmentGeneratorParameters(globalParameters);
        } catch (ApplicationException ae) {
            LOG.error("Could not saveShipmentGeneratorParameters", ae);
            // TODO (MH) Read error code and trigger FE error handling
        }
    }

    /**
     * @return whether the order generator is running
     */
    public boolean isOrderGeneratorRunning() {
        try {
            return SHIPMENT_SIMULATOR_MANAGER.isShipmentGeneratorRunning();
        } catch (ApplicationException ae) {
            LOG.error("Could not find out if Shipment Generator is running", ae);
            // TODO (MH) Read error code and trigger FE error handling
            return false;
        }
    }

    /**
     * @param orderNumber the orderNumber to set for searching
     */
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    /**
     * Actionlistener on "get order" button
     * @param event ignored
     */
    public void updateOrder(ActionEvent event) {
        try {
            orderShipping = SHIPMENT_SIMULATOR_MANAGER.getOrderShipping(orderNumber);
        } catch (ApplicationException e) {
            LOG.error("Could not getOrderShipping for orderNumber " + orderNumber, e);
            // TODO (MH) Read error code and trigger FE error handling
        }
        if (orderShipping != null) {
            orderFound = true;
            shippingState = orderShipping.getShippingState();
            customerNumber = orderShipping.getCustomerNumber();
            try {
                shipments = SHIPMENT_SIMULATOR_MANAGER.getShipments(orderShipping);
            } catch (ApplicationException e) {
                LOG.error("Could not getShipments for orderShipping " + orderShipping, e);
                // TODO (MH) Read error code and trigger FE error handling
            }
        } else {
            orderFound = false;
        }
    }

    /**
     * @return the orderNumber
     */
    public String getOrderNumber() {
        return this.orderNumber;
    }

    /**
     * @return the orderFound
     */
    public boolean isOrderFound() {
        return this.orderFound;
    }

    /**
     * @return the SHIPMENT_SIMULATOR_MANAGER
     */
    public ShipmentSimulatorManager getSHIPMENT_SIMULATOR_MANAGER() {
        return SHIPMENT_SIMULATOR_MANAGER;
    }

    /**
     * @return the shippingState
     */
    public ShippingState getShippingState() {
        return shippingState;
    }

    /**
     * @return the customerNumber
     */
    public String getCustomerNumber() {
        return customerNumber;
    }

    /*
     * CURRENTLY NOT AVAILABLE IN ShipmentSimulatorFeController
     * Is called when the user presses the start-generator button.
     * @param event ignored
    //     */
    //    public void startGenerator(ActionEvent event) {
    //        if (LOG.isDebugEnabled()) {
    //            LOG.debug(">> startGenerator()");
    //        }
    //        actionWasSuccess = SHIPMENT_SIMULATOR_MANAGER.startShipmentGenerator(globalParameters);
    //        if (actionWasSuccess) {
    //            action = START;
    //            actionHistory.add(new Action(action, new Date()));
    //        }
    //    }
    //    /**
    //     * CURRENTLY NOT AVAILABLE IN ShipmentSimulatorFeController
    //     * Is called when the user presses the stop-generator button.
    //     * @param event ignored
    //     */
    //    public void stopGenerator(ActionEvent event) {
    //        if (LOG.isDebugEnabled()) {
    //            LOG.debug(">> stopGenerator()");
    //        }
    //        actionWasSuccess = SHIPMENT_SIMULATOR_MANAGER.stopShipmentGenerator();
    //        if (actionWasSuccess) {
    //            action = STOP;
    //            actionHistory.add(new Action(action, new Date()));
    //        }
    //    }
    //generatorTimeMode
    //    /**
    //     * 
    //     */
    //    public List<SelectItem> getGeneratorTimeModeItems() {
    //        List<SelectItem> list = new ArrayList<SelectItem> ();
    //        for (GlobalParameters.GeneratorTimeMode mode : GlobalParameters.GeneratorTimeMode.values()) {
    //            list.add(new SelectItem(mode, mode.toString()));
    //        }
    //        return list;
    //    }
}
