/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.test.services;

import static org.junit.Assert.*;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.shipment_simulator.be.remote.ServiceManager;

/**
 * JUnit test for the the 
 * {@link de.itemis.qimpress.showcase.shipment_simulator.be.remote.ServiceManager} 
 * service methods. As the tested methods call WebServices, it is required that
 * the corresponding WebServices are up and running before these tests get started.
 * 
 * 
 * @author Wladimir Safonov
 *
 */
public class ServiceManagerTest {
    
    private static final Logger LOG = Logger.getLogger(ServiceManagerTest.class);
    
    private static ServiceManager SERVICE_MANAGER;
    
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }
        
        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        SERVICE_MANAGER = (ServiceManager) ctxt.getBean("serviceManager");
        assertNotNull("Failed to load ServiceManager", SERVICE_MANAGER);
    }

    @Test
    public void testCheckProductAvailability() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testCheckProductAvailability()");
        }

        int productAvailability = -1;
        try {
            productAvailability = SERVICE_MANAGER.checkProductAvailability("PROD001", 10);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to invoke checkProductAvailability");
        }
        assertTrue("Received unexpected availability value", (productAvailability >= 0) && (productAvailability <= 10));
        
    }
}
