/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.test.manager;

import static org.junit.Assert.*;

import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;

import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.ServiceLocator;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;

/**
 * JUnit test class for
 * {@link de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager}.
 * 
 * @author Wladimir Safonov
 *
 */
public class ShipmentSimulatorManagerTest {

    private static final Logger LOG = Logger.getLogger(ShipmentSimulatorManagerTest.class);
    
    private static final ShipmentSimulatorManager SHIPMENT_SIMULATOR_MANAGER = ServiceLocator.getInstance().getShipmentSimulatorManager();
    
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }
        
        
        assertNotNull("Failed to locate ShipmentSimulatorManager instance over ServiceLocator: result is null", SHIPMENT_SIMULATOR_MANAGER);
    }
    
    @Test
    public void testLoadGlobalParameters() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testLoadGlobalParameters()");
        }
        
        GlobalParameters globalParameters = null;
        try {
            globalParameters = SHIPMENT_SIMULATOR_MANAGER.loadShipmentGeneratorParameters();
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to load GlobalParameters");
        }
        assertNotNull("Failed to load GlobalParameters: result is null", globalParameters);
//        assertNotNull("Failed to load GlobalParameters: CustomerTypeParameters is null", 
//                globalParameters.getTypeSpecificParameters());
//        assertTrue("Failed to load GlobalParameters: CustomerTypeParameters is empty", 
//                globalParameters.getTypeSpecificParameters().size() > 0);
    }

    @Test
    public void testSaveGlobalParameters() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testSaveGlobalParameters()");
        }
        
        GlobalParameters globalParameters = new GlobalParameters();
        globalParameters.setMinShipmentInterval(1);
        globalParameters.setMaxShipmentInterval(5);
        
        try {
            SHIPMENT_SIMULATOR_MANAGER.saveShipmentGeneratorParameters(globalParameters);
        } catch (ApplicationException e) {
            e.printStackTrace();
            fail("Failed to save GlobalParameters");
        }
    }
    
    @Test
    public void testOrderGeneratorJob() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called testOrderGeneratorJob()");
        }
        
//        try {
//            GlobalParameters generatorParameters = SHIPMENT_SIMULATOR_MANAGER.loadShipmentGeneratorParameters();
//            generatorParameters.setGeneratorTimeMode(GeneratorTimeMode.SIMULATED_TIME);
//            OSG_APP_MANAGER.startShipmentGenerator(generatorParameters);
//            Thread.sleep(3000);
//            OSG_APP_MANAGER.stopShipmentGenerator();
//            Thread.sleep(3000);
//            OSG_APP_MANAGER.startShipmentGenerator(generatorParameters);
//            Thread.sleep(3000);
//            OSG_APP_MANAGER.stopShipmentGenerator();
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//            fail("Failed to start/stop generator");
//        }
    }
}
