/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.test.generator;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.ShipmentItem;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.generator.dao.ShipmentDao;

/**
 * Unit test class for
 * {@link ShipmentDao}.

 * @author Wladimir Safonov
 *
 */
public class ShipmentDaoTest {

    private static final Logger LOG = Logger.getLogger(ShipmentDaoTest.class);
    
    private static ShipmentDao SHIPMENT_DAO;
    
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }
        
        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        try {
            SHIPMENT_DAO = (ShipmentDao) ctxt.getBean("shipmentDao");
        } catch (BeansException e) {
            fail("Failed to load ShipmentDao from the application context");
        }
    }

    @Test
    public void testSaveShipment() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testSaveShipment()");
        }
        
        Shipment newShipment = new Shipment();
        newShipment.setDispatchDate(new Date());
        newShipment.setTrackingCode("TRACK0001");
        newShipment.setOrderShipping(new OrderShipping(1L));
        
        List<ShipmentItem> shipmentItems = new LinkedList<ShipmentItem>();
        ShipmentItem shipmentItem = new ShipmentItem();
        shipmentItem.setShippedProductCode("PROD001");
        shipmentItem.setShippedQuantity(4);
        shipmentItems.add(shipmentItem);
        shipmentItem = new ShipmentItem();
        shipmentItem.setShippedProductCode("PROD002");
        shipmentItem.setShippedQuantity(3);
        shipmentItems.add(shipmentItem);
        
        newShipment.setShipmentItems(shipmentItems);
        
        try {
            SHIPMENT_DAO.save(newShipment);
        } catch (DaoException e) {
            e.printStackTrace();
            fail("Failed to store Shipment");
        }
    }
}
