/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.test.generator;

import static org.junit.Assert.*;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.ItemShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.ShippingState;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.generator.dao.OrderShippingDao;

/**
 * Unit test class for
 * {@link OrderDao}.
 * 
 * @author Wladimir Safonov
 * @author Claudius Haecker
 */
public class OrderShippingDaoTest {

    private static final Logger LOG = Logger.getLogger(OrderShippingDaoTest.class);

    private static OrderShippingDao ORDER_SHIPPING_DAO;

    /**
     * Initializes constants.
     */
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }

        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        try {
            ORDER_SHIPPING_DAO = (OrderShippingDao) ctxt.getBean("orderShippingDao");
        } catch (BeansException e) {
            fail("Failed to load OrderShippingDao from the application context");
        }
    }

    /**
     * requests pending <code>OrderShipping</code>s and tests that they are in state "pending".
     */
    @Test
    public void testGetPending() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testGetPending()");
        }

        List<OrderShipping> pendingOrderShippings = null;
        try {
            pendingOrderShippings = ORDER_SHIPPING_DAO.getPending(new Date());
        } catch (DaoException e) {
            e.printStackTrace();
            fail("Failed to load pending OrderShippings");
        }
        assertNotNull("Failed to load pending OrderShippings: result is null", pendingOrderShippings);
        assertEquals("Unexpected number of pending OrderShippings", 2, pendingOrderShippings.size());
        for (OrderShipping orderShipping : pendingOrderShippings) {
            assertTrue("OrderShipping has unexpected state", orderShipping.getShippingState().isPending());
        }

    }

    /**
     * saves an <code>OrderShipping</code> with two <code>ItemShipping</code>s and ensures that no <code>DaoException</code> is thrown.<br/>
     * Before running this test execute:<br/>
     * DELETE FROM item_shipping WHERE product_code like 'PROD0_';<br/>
     * DELETE FROM shipment_item WHERE shipment_id IN (SELECT shipment_id FROM shipment WHERE order_shipping_id IN
     *  (SELECT order_shipping_id FROM order_shipping WHERE order_number = 'ORDER'));<br/>
     * DELETE FROM shipment WHERE order_shipping_id IN (SELECT order_shipping_id FROM order_shipping WHERE order_number = 'ORDER');<br/>
     * DELETE FROM order_shipping WHERE order_number = 'ORDER';
     */
    @Test
    public void testSaveList() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testSaveList()");
        }

        OrderShipping orderShipping = new OrderShipping();
        orderShipping.setOrderNumber("ORDER");
        orderShipping.setCustomerNumber("CUSTOMER");
        orderShipping.setNextProcessingDate(new Date());
        orderShipping.setShippingState(new ShippingState(1L));

        List<ItemShipping> itemShippings = new LinkedList<ItemShipping>();
        ItemShipping itemShipping = new ItemShipping();
        itemShipping.setProductCode("PROD01");
        itemShipping.setLeftQuantity(5);
        itemShippings.add(itemShipping);
        itemShipping = new ItemShipping();
        itemShipping.setProductCode("PROD02");
        itemShipping.setLeftQuantity(10);
        itemShippings.add(itemShipping);
        orderShipping.setItemShippings(itemShippings);

        List<OrderShipping> orderShippings = new LinkedList<OrderShipping>();
        orderShippings.add(orderShipping);

        try {
            ORDER_SHIPPING_DAO.save(orderShippings);
        } catch (DaoException e) {
            e.printStackTrace();
            fail("Failed to save list of OrderShippings");
        }
    }
}
