/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.test.generator;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

import org.apache.log4j.Logger;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.oxm.Marshaller;

import de.itemis.qimpress.showcase.shipment_simulator.be.dto.Order;
import de.itemis.qimpress.showcase.shipment_simulator.be.dto.OrderItem;
import de.itemis.qimpress.showcase.shipment_simulator.be.dto.OrdersBatch;
import de.itemis.qimpress.showcase.shipment_simulator.be.test.mock.TextMessageMock;

/** 
 * Unit test class for 
 * {@link de.itemis.qimpress.showcase.shipment_simulator.be.generator.IncomingOrdersMessageListener}
 * @author Wladimir Safonov
 *
 */
public class IncomingOrdersMessageListenerTest {

    private static final Logger LOG = Logger.getLogger(IncomingOrdersMessageListenerTest.class);
    
    private static MessageListener INCOMING_ORDERS_HANDLER;
    private static Marshaller MARSHALLER;
    
    @BeforeClass
    public static void initTestSuite() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> initTestSuite()");
        }
        
        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        try {
            INCOMING_ORDERS_HANDLER = (MessageListener) ctxt.getBean("incomingOrdersHandler");
            MARSHALLER = (Marshaller) ctxt.getBean("castorMarshaller");
        } catch (BeansException e) {
            fail("Failed to load IncomingOrdersMessageListener from the application context");
        }
    }

    @Test
    public void testOnMessage() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> testOnMessage()");
        }

        // create test data objects
        OrdersBatch ordersBatch = new OrdersBatch();
        List<Order> orders = new LinkedList<Order>();
        ordersBatch.setOrders(orders);
        
        Order order = new Order("OR001", new Date(), "010203", new BigDecimal("345.38"));
        orders.add(order);
        
        List<OrderItem> orderItems = new LinkedList<OrderItem>();
        orderItems.add(new OrderItem(5, "PROD001", new BigDecimal("34.58")));
        orderItems.add(new OrderItem(10, "PROD002", new BigDecimal("53.34")));
        orderItems.add(new OrderItem(15, "PROD003", new BigDecimal("283.73")));
        order.setOrderItems(orderItems);
        
        // marshall test data objects to the XML
        JDOMResult jDomResult = new JDOMResult();
        try {
            MARSHALLER.marshal(ordersBatch, jDomResult);
        } catch (Exception e) {
            e.printStackTrace();
            fail("Unexpected failure during TextMessage construction");
        }
        
        // output XML with test data objects to String
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        String testMessage = xmlOutputter.outputString(jDomResult.getDocument());

        // create mocked TextMessage
        TextMessage textMessage = new TextMessageMock();
        try {
            textMessage.setText(testMessage);
        } catch (JMSException e) {
            // no exception in mock
        }
        
        // test onMessage()
        INCOMING_ORDERS_HANDLER.onMessage(textMessage);
    }
}

