/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.generator;

import static org.junit.Assert.*;

import java.util.Date;

import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.TimeParameters;

/**
 * @author Claudius Haecker
 *
 */
public class ShipmentGeneratorJobTest {

    private static final Logger LOG = Logger.getLogger(ShipmentGeneratorJobTest.class);
    private static ShipmentGeneratorJob SHIPMENT_GENERATOR_JOB;
    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called setUpBeforeClass()");
        }

        ApplicationContext ctxt = new ClassPathXmlApplicationContext("applicationContext.xml");
        assertNotNull("Failed to load context", ctxt);
        SHIPMENT_GENERATOR_JOB = (ShipmentGeneratorJob) ctxt.getBean("shipmentGeneratorJob");
        assertNotNull("Failed to load shipmentGeneratorJob from the applicatonContext", SHIPMENT_GENERATOR_JOB);
    }

    /**
     * @throws java.lang.Exception
     */
    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    /**
     * @throws java.lang.Exception if error occurs
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws Exception if error occurs
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * Test method for
     * {@link de.itemis.qimpress.showcase.shipment_simulator.be.generator.ShipmentGeneratorJob#calculateCurrentVirtualTime(GlobalParameters)}.
     */
    @Test
    public void testCalculateCurrentVirtualTime() {
        fail("Not yet implemented");
        //        calculateCurrentVirtualTime
    }

    /**
     * Test method for
     * {@link de.itemis.qimpress.showcase.shipment_simulator.be.generator.ShipmentGeneratorJob#execute(de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters)}.
     * 
     */
    @Test
    public void testGeneratorLogic() {
        GlobalParameters globalParameters = new GlobalParameters();
        globalParameters.setMinShipmentInterval(2);
        globalParameters.setMaxShipmentInterval(3);
        TimeParameters timeParameters = new TimeParameters();
        timeParameters.setGeneratorTimeMode(TimeParameters.GeneratorTimeMode.SIMULATED_TIME);
        timeParameters.setStartTimeForOrders(new Date());
        timeParameters.setStartTimeOfGenerator(new Date());
        timeParameters.setTimeScaleFactor(1F);
        globalParameters.setTimeParameters(timeParameters);
        
        try {
            SHIPMENT_GENERATOR_JOB.execute(globalParameters);
        } catch (DaoException de) {
            fail("caught DaoException: \n" + de.getMessage() + "\n" + de.getStackTrace());
        }
        
    }

}
