/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.remote;

import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.ApplicationException;

/**
 * 
 * Service interface for the functions of external systems 
 * used in the Shipment Simulator.
 * <p>
 * Includes interface to the Inventory system for requesting 
 * product availability
 * 
 * @author Wladimir Safonov
 *
 */
public interface ServiceManager {

    /**
     * Request product availability for the given product code and quantity
     * from the Inventory system.
     * 
     * @param productCode code of the product to check availability of
     * @param quantity quantity of the product to check for availability
     * @return quantity of the product available from the requested (&lt; quantity)
     * @throws ApplicationException in case of remote service failure
     */
    int checkProductAvailability(String productCode, int quantity) throws ApplicationException;
}
