/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.manager.model;

/**
 * Class representing general configuration data for the generator.
 * 
 * @author Wladimir Safonov
 *
 */
public class GlobalParameters {

    /** minimal interval between shipments (in days) */
    private int minShipmentInterval;
    /** maximal interval between shipments (in days) */
    private int maxShipmentInterval;
    /** generator time mode parameters */
    private TimeParameters timeParameters;

    /**
     * Getter for the minimal interval between shipments.
     * 
     * @return the minShipmentInterval
     */
    public int getMinShipmentInterval() {
        return minShipmentInterval;
    }

    /**
     * Setter for the minimal interval between shipments.
     * 
     * @param minShipmentInterval the minShipmentInterval to set
     */
    public void setMinShipmentInterval(int minShipmentInterval) {
        this.minShipmentInterval = minShipmentInterval;
    }

    /**
     * Getter for the maximal interval between shipments.
     * 
     * @return the maxShipmentInterval
     */
    public int getMaxShipmentInterval() {
        return maxShipmentInterval;
    }

    /**
     * Setter for the maximal interval between shipments.
     * 
     * @param maxShipmentInterval the maxShipmentInterval to set
     */
    public void setMaxShipmentInterval(int maxShipmentInterval) {
        this.maxShipmentInterval = maxShipmentInterval;
    }

    /**
     * Getter for the generator time mode parameters.
     * 
     * @return the timeParameters
     */
    public TimeParameters getTimeParameters() {
        return timeParameters;
    }

    /**
     * Setter for the generator time mode parameters.
     * 
     * @param timeParameters the timeParameters to set
     */
    public void setTimeParameters(TimeParameters timeParameters) {
        this.timeParameters = timeParameters;
    }

}
