/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.manager.dao;

import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;

/**
 * DAO interface for loading and storing objects of the
 * {@link de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters} 
 * class.
 * 
 * @author Wladimir Safonov
 *
 */
public interface GlobalParametersDao {

    /**
     * Loads stored
     * {@link de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters}
     * from the database.
     * @return stored
     * {@link de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters}
     * @throws DaoException in case of a database failure
     */
    public GlobalParameters load() throws DaoException;
    
    /**
     * Stores the given
     * {@link de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters}
     * in the database.
     * 
     * @param globalParameters
     * {@link de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters}
     * to store
     * @throws DaoException in case of a database failure
     */
    public void store(GlobalParameters globalParameters) throws DaoException;
}
