/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.manager;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.shipment_simulator.be.dao.OrderReportDao;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.ApplicationException.ApplicationErrorCode;
import de.itemis.qimpress.showcase.shipment_simulator.be.generator.GeneratorManager;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.dao.GlobalParametersDao;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.TimeParameters;

/**
 * @author Wladimir Safonov
 * @author Claudius Haecker
 *
 */
public class ShipmentSimulatorManagerImpl implements ShipmentSimulatorManager {

    private static final Logger LOG = Logger.getLogger(ShipmentSimulatorManagerImpl.class);

    private GlobalParametersDao globalParametersDao;
    private GeneratorManager generatorManager;
    private OrderReportDao orderReportDao;

    /**
     * @param globalParametersDao the globalParametersDao to set
     */
    public void setGlobalParametersDao(GlobalParametersDao globalParametersDao) {
        this.globalParametersDao = globalParametersDao;
    }

    /**
     * @param generatorManager the generatorManager to set
     */
    public void setGeneratorManager(GeneratorManager generatorManager) {
        this.generatorManager = generatorManager;
    }

    /**
     * @param orderReportDao the orderReportDao to set
     */
    public void setOrderReportDao(OrderReportDao orderReportDao) {
        this.orderReportDao = orderReportDao;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager#isOrderGeneratorRunning()
     */
    /* @Override */
    public boolean isShipmentGeneratorRunning() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called isShipmentGeneratorRunning()");
        }

        return generatorManager.isShipmentGeneratorRunning();
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager#loadOrderGeneratorParameters()
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true)
    public GlobalParameters loadShipmentGeneratorParameters() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called loadOrderGeneratorParameters()");
        }

        try {
            return globalParametersDao.load();
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager#saveOrderGeneratorParameters(de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters)
     */
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED)
    public void saveShipmentGeneratorParameters(GlobalParameters parameters) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("called saveOrderGeneratorParameters()");
        }

        try {
            globalParametersDao.store(parameters);
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager#startOrderGenerator(de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters)
     */
    /* @Override */
    public boolean startShipmentGenerator(TimeParameters timeParameters) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> startShipmentGenerator()");
        }

        // load order generation parameters 
        GlobalParameters globalParameters = this.loadShipmentGeneratorParameters();
        // set time parameters
        globalParameters.setTimeParameters(timeParameters);

        return generatorManager.startShipmentGenerator(globalParameters);
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager#stopOrderGenerator()
     */
    /* @Override */
    public boolean stopShipmentGenerator() throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> stopShipmentGenerator()");
        }

        return generatorManager.stopShipmentGenerator();
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager#getShipments()
     */
    /* @Override */
    public List<Shipment> getShipments(OrderShipping orderShipping) throws ApplicationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getShipments(orderShipping)");
        }
        try {
            return orderReportDao.getShipments(orderShipping);
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.manager.ShipmentSimulatorManager#getOrderShipping()
     */
    /* @Override */
    public OrderShipping getOrderShipping(String orderNumber) throws ApplicationException {
        try {
            return orderReportDao.getOrderShipping(orderNumber);
        } catch (DaoException e) {
            throw new ApplicationException(ApplicationErrorCode.TE, e);
        }
    }
}
