/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.manager;

import java.util.List;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.ApplicationException;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.TimeParameters;

/**
 * Configuration and controlling interface for the Shipment Simulator
 * application. Allows to load/save shipment generator parameters and
 * to start/stop shipment generator.
 * 
 * @author Wladimir Safonov
 * @author Claudius Haecker
 */
public interface ShipmentSimulatorManager {

    /**
     * Starts the shipment generator with the given time parameters.
     * 
     * @param timeParameters time parameters for the shipment generation
     * @return true if succeeded
     * @throws ApplicationException in case of an internal application failure
     */
    public boolean startShipmentGenerator(TimeParameters timeParameters) throws ApplicationException;

    /**
     * Stops the shipment generator
     * 
     * @return true if succeeded
     * @throws ApplicationException in case of an internal application failure
     */
    public boolean stopShipmentGenerator() throws ApplicationException;

    /**
     * Checks the status of the shipment generator.
     * 
     * @return true if the shipment generator is running
     * @throws ApplicationException in case of an internal application failure
     */
    public boolean isShipmentGeneratorRunning() throws ApplicationException;

    /**
     * Loads parameters of the shipment generator.
     * 
     * @return shipment generation parameters
     * @throws ApplicationException in case of an internal application failure
     */
    public GlobalParameters loadShipmentGeneratorParameters() throws ApplicationException;

    /**
     * Saves shipment generator parameters.
     * 
     * @param parameters shipment generator parameters
     * @throws ApplicationException in case of an internal application failure
     */
    public void saveShipmentGeneratorParameters(GlobalParameters parameters) throws ApplicationException;

    /**
     * Retrieves a list of ShipmentReports that belong to a given orderShipping
     * @param orderShipping the OrderShipping whose Shipments are to be retrieved
     * @return a list of ShipmentReports that belong to the orderShipping
     * @throws ApplicationException 
     */
    public List<Shipment> getShipments(OrderShipping orderShipping) throws ApplicationException;

    /**
     * @param orderNumber
     * @return {@link OrderShipping} for the given orderNumber
     * @throws ApplicationException
     */
    public OrderShipping getOrderShipping(String orderNumber) throws ApplicationException;

}
