/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.generator.dao;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;

/**
 * @author Wladimir Safonov
 *
 */
public class ShipmentDaoImpl extends HibernateDaoSupport implements ShipmentDao {

    private static final Logger LOG = Logger.getLogger(ShipmentDaoImpl.class);
    
    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.generator.dao.ShipmentDao#save(de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment)
     */
    /* @Override */
    public void save(Shipment shipment) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> save()");
        }
        
        try {
            getHibernateTemplate().saveOrUpdate(shipment);
        } catch (DataAccessException e) {
            LOG.error("Failed to store Shipment", e);
            throw new DaoException(e);
        }
    }

}
