/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.generator.dao;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.ShippingState;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;

/**
 * @author Wladimir Safonov
 *
 */
public class OrderShippingDaoImpl extends HibernateDaoSupport implements OrderShippingDao {

    private static final Logger LOG = Logger.getLogger(OrderShipping.class);
    
    private Map<String, ShippingState> shippingStatesMap;
    
    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.generator.dao.OrderShippingDao#getByOrderNumber(java.lang.String)
     */
    @SuppressWarnings("unchecked")
    /* @Override */
    @Transactional(propagation = Propagation.REQUIRED, readOnly = true, isolation = Isolation.READ_COMMITTED)
    public List<OrderShipping> getPending(Date untilProcessingDate) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getPending()");
        }
        
        List<OrderShipping> pendingOrderShippings = null;
        try {
            pendingOrderShippings = getHibernateTemplate().find(
                    "from OrderShipping os where (os.shippingState.stateName=? or os.shippingState.stateName=?) and " +
                                                "os.nextProcessingDate<=?",
                    new Object[] {ShippingState.OPEN, ShippingState.PARTIALLY_DELIVERED, untilProcessingDate});
        } catch (DataAccessException e) {
            LOG.error("Failed to load pending OrderShippings", e);
            throw new DaoException(e);
        }
        return pendingOrderShippings;
    }

    /* @Override */
    public void save(List<OrderShipping> orderShippings) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> save()");
        }
        
        try {
            getHibernateTemplate().saveOrUpdateAll(orderShippings);
        } catch (DataAccessException e) {
            LOG.error("Failed to store a list of OrderShippings", e);
            throw new DaoException(e);
        }
    }

    /* @Override */
    public ShippingState getShippingState(String stateName) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getShippingState()");
        }
        
        // init shipping states map if required
        if (null == shippingStatesMap) {
            shippingStatesMap = new HashMap<String, ShippingState>();
            List<ShippingState> shippingStatesList = getHibernateTemplate().find("from ShippingState");
            for (ShippingState shippingState : shippingStatesList) {
                shippingStatesMap.put(shippingState.getStateName(), shippingState);
            }
        }
        return shippingStatesMap.get(stateName);
    }
}
