/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.generator;

import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;

/**
 * Generator control interface. Allows to start/stop the generator
 * and to get its current status.
 * 
 * @author Wladimir Safonov
 *
 */
public interface GeneratorManager {

    /**
     * Starts shipment generator with the given parameters.
     * 
     * @param parameters parameters for the shipment generation
     * @return true if succeeded
     */
    public boolean startShipmentGenerator(GlobalParameters parameters);
    
    /**
     * Stops shipment generator.
     * 
     * @return true if succeeded
     */
    public boolean stopShipmentGenerator();
    
    /**
     * Checks the status of the shipment generator.
     * 
     * @return true if the shipment generator is running
     */
    public boolean isShipmentGeneratorRunning();
    
}
