/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * Information about the shipping state.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "shipping_state")
public class ShippingState {

    public static final String OPEN = "OPEN";
    public static final String PARTIALLY_DELIVERED = "PARTIALLY_DELIVERED";
    public static final String COMPLETELY_DELIVERED = "COMPLETELY_DELIVERED";
    
    public static final String[] PENDING = {OPEN, PARTIALLY_DELIVERED};
    
    
    /** primary key */
    private Long id;
    
    /** shipping state name */
    private String stateName;

    public ShippingState() {
        super();
    }

    public ShippingState(Long id) {
        super();
        this.id = id;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "shipping_state_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the stateName
     */
    @Column(name = "state_name")
    public String getStateName() {
        return stateName;
    }

    /**
     * @param stateName the stateName to set
     */
    public void setStateName(String stateName) {
        this.stateName = stateName;
    }
    
    /**
     * Checks if this <code>ShippingState</code> describes a pending state,
     * that is a state from which <code>Shipments</code> can still happen 
     * (<code>OPEN</code> or <code>PARTIALLY_DELIVERED</code>, e.g.).
     * 
     * @return true if this is a pending state
     */
    @Transient
    public boolean isPending() {
        return OPEN.equals(this.stateName) || PARTIALLY_DELIVERED.equals(this.stateName);
    }
    
    /**
     * Return a list of pending states names (@see {@link #isPending()}).
     * 
     * @return list of pending states names
     */
    public static String[] getPendingStatesNames() {
        return PENDING;
    }
    
}
