/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Information about shipment items making up a single shipment. 
 * Each shipment item refers a product, which is shipped in a certain shippedQuantity.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "shipment_item")
public class ShipmentItem {

    /** primary key */
    private Long id;

    /** code of the product referred by this item */
    private String shippedProductCode;
    /** shipped product quantity */
    private int shippedQuantity;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "shipment_item_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the shippedProductCode
     */
    @Column(name = "shipped_product_code")
    public String getShippedProductCode() {
        return shippedProductCode;
    }

    /**
     * @param shippedProductCode the shippedProductCode to set
     */
    public void setShippedProductCode(String shippedProductCode) {
        this.shippedProductCode = shippedProductCode;
    }

    /**
     * @return the shippedQuantity
     */
    @Column(name = "shipped_quantity")
    public int getShippedQuantity() {
        return shippedQuantity;
    }

    /**
     * @param shippedQuantity the shippedQuantity to set
     */
    public void setShippedQuantity(int shippedQuantity) {
        this.shippedQuantity = shippedQuantity;
    }

}
