/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.domain;

import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * Information about a single shipment event.
 * Includes shipment dispatchDate, order shipping information and shipment tracking code.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "shipment")
public class Shipment {

    /** primary key */
    private Long id;

    /** shipment tracking code */
    private String trackingCode;
    /** date of dispatch */
    private Date dispatchDate;
    /** shipment items (info about shipped products) */
    private List<ShipmentItem> shipmentItems;
    /** information about the order shipping */
    private OrderShipping orderShipping;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "shipment_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the trackingCode
     */
    @Column(name = "tracking_code")
    public String getTrackingCode() {
        return trackingCode;
    }

    /**
     * @param trackingCode the trackingCode to set
     */
    public void setTrackingCode(String trackingCode) {
        this.trackingCode = trackingCode;
    }

    /**
     * @return the dispatchDate
     */
    @Column(name = "dispatch_date")
    public Date getDispatchDate() {
        return dispatchDate;
    }

    /**
     * @param dispatchDate the dispatchDate to set
     */
    public void setDispatchDate(Date dispatchDate) {
        this.dispatchDate = dispatchDate;
    }

    /**
     * @return the shipmentItems
     */
    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    @JoinColumn(name = "shipment_id")
    public List<ShipmentItem> getShipmentItems() {
        return shipmentItems;
    }

    /**
     * @param shipmentItems the shipmentItems to set
     */
    public void setShipmentItems(List<ShipmentItem> shipmentItems) {
        this.shipmentItems = shipmentItems;
    }

    /**
     * @return the orderShipping
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "order_shipping_id")
    public OrderShipping getOrderShipping() {
        return orderShipping;
    }

    /**
     * @param orderShipping the orderShipping to set
     */
    public void setOrderShipping(OrderShipping orderShipping) {
        this.orderShipping = orderShipping;
    }

}
