/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.domain;

import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * Class holding shipping information about the order. 
 * Includes order number, customer number, current shipping state, 
 * date of the next processing as well as item shipping information.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "order_shipping")
public class OrderShipping {

    /** primary key */
    private Long id;

    /** order number */
    private String orderNumber;
    /** customer number */
    private String customerNumber;
    /** shipping state */
    private ShippingState shippingState;
    /** date of the next processing (possible shipment) */
    private Date nextProcessingDate;
    /** information about order items shipping */
    private List<ItemShipping> itemShippings;

    public OrderShipping() {
    }

    public OrderShipping(Long id) {
        super();
        this.id = id;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "order_shipping_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the orderNumber
     */
    @Column(name = "order_number", unique = true)
    public String getOrderNumber() {
        return orderNumber;
    }

    /**
     * @param orderNumber the orderNumber to set
     */
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    /**
     * @return the customerNumber
     */
    @Column(name = "customer_number")
    public String getCustomerNumber() {
        return customerNumber;
    }

    /**
     * @param customerNumber the customerNumber to set
     */
    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    /**
     * @return the shippingState
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "shipping_state_id")
    public ShippingState getShippingState() {
        return shippingState;
    }

    /**
     * @param shippingState the shippingState to set
     */
    public void setShippingState(ShippingState shippingState) {
        this.shippingState = shippingState;
    }

    /**
     * @return the nextProcessingDate
     */
    @Column(name = "next_processing_date")
    public Date getNextProcessingDate() {
        return nextProcessingDate;
    }

    /**
     * @param nextProcessingDate the nextProcessingDate to set
     */
    public void setNextProcessingDate(Date nextProcessingDate) {
        this.nextProcessingDate = nextProcessingDate;
    }

    /**
     * @return the itemShippings
     */
    @OneToMany(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    @JoinColumn(name = "order_shipping_id")
    public List<ItemShipping> getItemShippings() {
        return itemShippings;
    }

    /**
     * @param itemShippings the itemShippings to set
     */
    public void setItemShippings(List<ItemShipping> itemShippings) {
        this.itemShippings = itemShippings;
    }

}
