/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Class holding information about the item shipping.
 * Includes referenced product code and product quantity left to ship out.
 * 
 * @author Wladimir Safonov
 *
 */
@Entity
@Table(name = "item_shipping")
public class ItemShipping {

    /** primary key */
    private Long id;

    /** product code */
    private String productCode;
    /** product quantity to ship */
    private int leftQuantity;

    public ItemShipping() {
    }

    public ItemShipping(String productCode, int leftQuantity) {
        this.productCode = productCode;
        this.leftQuantity = leftQuantity;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue
    @Column(name = "item_shipping_id")
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    private void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the productCode
     */
    @Column(name = "product_code")
    public String getProductCode() {
        return productCode;
    }

    /**
     * @param productCode the productCode to set
     */
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    /**
     * @return the leftQuantity
     */
    @Column(name = "left_quantity")
    public int getLeftQuantity() {
        return leftQuantity;
    }

    /**
     * @param leftQuantity the leftQuantity to set
     */
    public void setLeftQuantity(int leftQuantity) {
        this.leftQuantity = leftQuantity;
    }

}
