/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.dao;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;
import de.itemis.qimpress.showcase.shipment_simulator.be.manager.model.GlobalParameters;

/**
 * @author Claudius Haecker
 *
 */
public class OrderReportDaoImpl extends HibernateDaoSupport implements OrderReportDao {
    private static final Logger LOG = Logger.getLogger(OrderReportDaoImpl.class);

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.dao.OrderReportDao#getShipments(de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping)
     */
    public List<Shipment> getShipments(OrderShipping orderShipping) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getShipments");
        }
        List<Shipment> shipments = null;
        try {
            shipments = getHibernateTemplate().find("from Shipment s where s.orderShipping=?",
                    new Object[] { orderShipping });
        } catch (DataAccessException e) {
            LOG.error("Failed to load shipments for OrderShipping "
                    + (orderShipping == null ? "which is null" : (" with id " + orderShipping.getId())), e);
            throw new DaoException(e);
        }
        return shipments;
    }

    /* (non-Javadoc)
     * @see de.itemis.qimpress.showcase.shipment_simulator.be.dao.OrderReportDao#getOrderShipping(java.lang.String)
     */
    public OrderShipping getOrderShipping(String orderNumber) throws DaoException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> getOrderShipping");
        }
        OrderShipping orderShipping = null;
        List<OrderShipping> orderShippings;
        try {
            orderShippings = getHibernateTemplate().find("from OrderShipping as os where os.orderNumber = ?",
                    orderNumber);
        } catch (DataAccessException e) {
            LOG.error("Failed to load OrderShipping with orderNumber " + orderNumber, e);
            throw new DaoException(e);
        }
        int count = (orderShippings == null ? 0 : orderShippings.size());
        if (count >= 1) {
            orderShipping = orderShippings.get(0);
        }
        if (count != 1) {
            LOG.error("Found " + count + " OrderShippings with orderNumber " + orderNumber
                    + ", exactly one was expected.");
        }
        return orderShipping;
    }

}