/*******************************************************************************
 * Copyright (c) 2008,2009 Q-ImPrESS consortium
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This work was funded in the context of the Q-ImPrESS research project  
 * (FP7-215013) by the European Union under the Information and  
 * Communication Technologies priority of the Seventh Research Framework  
 * Programme.
 *
 * Contributors:
 *     itemis 	- initial API and implementation
 *******************************************************************************/
package de.itemis.qimpress.showcase.shipment_simulator.be.dao;

import java.util.List;

import de.itemis.qimpress.showcase.shipment_simulator.be.domain.OrderShipping;
import de.itemis.qimpress.showcase.shipment_simulator.be.domain.Shipment;
import de.itemis.qimpress.showcase.shipment_simulator.be.exceptions.DaoException;

/**
 * @author Claudius Haecker
 *
 */
public interface OrderReportDao {

    /**
     * Retrieves a list of ShipmentReports that belong to a given orderShipping
     * @param orderShipping the OrderShipping whose Shipments are to be retrieved
     * @return a list of ShipmentReports that belong to the orderShipping
     * @throws DaoException if an error occurred during retrieval
     */
    public abstract List<Shipment> getShipments(OrderShipping orderShipping) throws DaoException;

    /**
     * Looks for an <code>OrderShipping</code> with a given <code>orderNumber</code>.
     * @param orderNumber specifies which OrderShipping to get
     * @return the <code>OrderShipping</code> with the given code or <code>null</code> if nothing was found
     * @throws DaoException if the database query failed
     */
    public abstract OrderShipping getOrderShipping(String orderNumber) throws DaoException;

}
